<%@ page language="java" buffer="none" contentType="text/html; charset=utf-8" %>
<%@ page import="java.util.Collection" %>
<%@ page import="java.util.LinkedList" %>
<%@ page import="java.util.Iterator" %>
<%@ page import="java.util.Map" %>
<%@ page import="com.genesyslab.ail.Enumerator" %>
<%@ page import="com.genesyslab.ail.EnumValue" %>
<%@ page import="com.genesyslab.ail.AilLoader" %>
<%@ page import="com.genesyslab.ail.AilFactory" %>
<%@ page import="com.genesyslab.ail.Interaction" %>

<%
    /* get data from session
    */
    String idInteraction = (String)request.getParameter( "idInteraction" );

    AilFactory factory = AilLoader.getAilFactory();

    /* Class used for the processing of this panel
    */

    /* Get category list from a configuration bundle
       Here we use the Business Attribute 'disposition code' from CME
    */
    Enumerator dispositionCodeEnum = factory.getEnumerator("DispositionCode");
    String[] codeIds = null;
    String[] codeLabels = null;
    if (dispositionCodeEnum!=null) {
        Collection dispositionCodes = dispositionCodeEnum.getValues();
        codeIds = new String[dispositionCodes.size()];
        codeLabels = new String[dispositionCodes.size()];
        int i=0;
        EnumValue dispositionCode;
        for (Iterator it=dispositionCodes.iterator();it.hasNext();) {
            dispositionCode = (EnumValue)it.next();
            codeIds[i] = dispositionCode.getId();
            codeLabels[i] = dispositionCode.getDisplayName();
            i++;
        }
    }

    /* Get the current categories for the current interaction
       Data is stored in attached data / interaction properties depending on the interaction type
       This part can be changed to recover the disposition from another container as a file, a database...
    */
    boolean[] codeInInteraction = new boolean[codeIds.length];
    Interaction interaction = factory.getInteraction(idInteraction);
    Map uData = interaction.getAttachedData();
    Object dataValue = uData.get("DispositionCode");
    if (dataValue!=null) {
        for (int i=0;i<codeIds.length;i++) {
            codeInInteraction[i] = (codeIds[i].equals(dataValue));
        }
    }

    String controlsScript = "";
%>
<html>
  <head>
    <meta http-equiv="imagetoolbar" content="no">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <link rel="stylesheet" type="text/css" href="style.css"/>
    <script language="javascript" src="htmlcontrol.js"></script>
	<script language="javascript">
      window.parent.includeGDFunctionalities(window);

      function custom_load() {
        // The disposition code checked is recovered in the custom context
        var custom_context = window.parent.getCustomContext();
        if ( (custom_context != null) && (custom_context.codeChecked != null) ) {
          var j;
          for (j=0;j<custom_context.codeChecked.length;j++) {
            custom_codeControls[j].setCheck(custom_context.codeChecked[j]);
          }
        }

        activateGDFunctionalities();
        for(var inc = 0;inc < custom_codeControls.length;inc++)
          addControl(custom_codeControls[inc]);
        addControl(custom_applyControl);
        focusOnControl(custom_applyControl);
      }

      function custom_unload() {
        // The disposition code checked is stored in the custom context
        var custom_context = new Object();
        custom_context.codeChecked = new Array();
        var j;
        if (document.forms.applyCategoriesForm.elements.codeChecked != null) {
           for (j=0;j<custom_codeControls.length;j++) {
             custom_context.codeChecked[j] = custom_codeControls[j].isCheck();
          }
        }
        window.parent.setCustomContext(custom_context);
        unactivateGDFunctionalities();
      }
    </script>
  </head>
  <body class="scrollBar backgroundRoundedPanel" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onload="custom_load()" onunload="custom_unload()">
    <table class="fontName" width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
      <tr valign="top">
        <td class="editablePanelDarkShadow" width="1" align="left" rowspan="3"><img src="empty.gif"></td>
        <td class="editablePanelDarkShadow" height="1"><img src="empty.gif"></td>
        <td class="editablePanelLightShadow" width="1" align="right" rowspan="3"><img src="empty.gif"></td>
      </tr>
      <tr valign="top">
        <td class="editablePanelBackground" width="100%" align="left">
          <form  name="applyCategoriesForm" action="apply-codes.jsp" target="applyCategoriesHiddenFrame">
            <input type="hidden" name="idInteraction" value="<%=idInteraction%>" >
            <table width="100%" border="0" cellpadding="0" cellspacing="0">
<%
    String labelTmp = "";
    String imgName = "imgCheckCategory";
    String imgNameTmp ="";
    int i=0;
    if (codeIds != null) {
%>
              <tr height="4"><td colspan="2"></td></tr>
<%
        for (i=0;i<codeIds.length;i++) {
            labelTmp = codeLabels[i];
            imgNameTmp = imgName + i;
%>
              <tr>
                <td width="25" nowrap align="center">
<%
              controlsScript = controlsScript + "custom_codeControls[custom_codeControls.length] = custom_createHTMLCheckBox(\"" + imgNameTmp +"\", \"" + labelTmp + "\", " + codeInInteraction[i] + ", \"custom_modifyCheckImage(" + i + ")\");\n";
%>
				  <div id="<%= imgNameTmp %>" height="15"></div>
                  <input type="hidden" name="codeId" value="<%=codeIds[i]%>" >
                  <input type="hidden" name="codeChecked" value="<%=codeInInteraction[i]%>" >
                </td>
                <td class="editablePanelText" nowrap><%=labelTmp%></td>
              </tr>
<%
        }
%>
              <tr height="4"><td colspan="2"></td></tr>
<%
    }

    if (i == 0) {
%>
              <tr><td>&nbsp;</td></tr>
<%
    }
%>
            </table>
            <div id="applyDiv"></div>
          </form>
        </td>
      </tr>
      <tr valign="bottom">
        <td class="editablePanelLightShadow" height="1"><img src="empty.gif"></td>
      </tr>
      <tr style="visibility:hidden"><td><iframe name="applyCategoriesHiddenFrame" style="visibility:hidden" src="empty.htm" frameborder="no" width="0" height="0"></iframe></td></tr>
    </table>
    <script language="javascript">
      var custom_idInteraction = "<%=idInteraction%>";
      var custom_rootImgName = "<%=imgName%>";

      function custom_modifyCheckImage(idx) {
		document.forms.applyCategoriesForm.elements.codeChecked[idx].value = custom_codeControls[idx].isCheck();
		if (custom_codeControls[idx].isCheck()) {
          for(var inc = 0;inc < custom_codeControls.length;inc++) {
            if (inc != idx) {
              custom_codeControls[inc].setCheck(false);
              document.forms.applyCategoriesForm.elements.codeChecked[inc].value="false";
            }
          }
        }
      }

      function custom_applyCodes() {
        document.forms.applyCategoriesForm.submit();
      }

      var custom_codeControls = [];
      <%= controlsScript %>
      var custom_applyControl = custom_createHTMLButtonImage ("applyDiv", "Apply", ["btnapplys.gif","btnapplyg.gif","btnapplyd.gif"], 25, "custom_applyCodes()");

      // This line disable the IE context menu
      document.oncontextmenu = function(){return true;}
    </script>
  </body>
</html>
